import requests
import json
import configparser
from Log_in import sign_in
from datetime import datetime
"""
Use case 3:
This code demonstrates how to assign a device to a sector
"""
sign_in_data = sign_in()

Token = sign_in_data[0]
url = sign_in_data[1]

payload={}
headers = {
  'Authorization': 'Bearer ' + Token
}

def devices(page_url):
    response = requests.request("GET", page_url, headers=headers, data=payload)
    if response.status_code in [200]:
        for line in json.loads(response.text)["data"]:
            print("Serialnumber: " + line["id"])
        return json.loads(response.text)["links"]
    else:
        print(response.text)
        quit()


def location_sector(page_url):
    response = requests.request("GET", page_url, headers=headers, data=payload)
    if response.status_code in [200]:
        for line in json.loads(response.text)["data"]:
            print("ID: " + line["id"] + "\tName: " + (line["attributes"])["name"] )
        return json.loads(response.text)["links"]
    else:
        print(response.text)
        quit()


def pagination(api_url, wanted_func):

    if wanted_func == "device":
        wanted_function = devices
    elif wanted_func == "location/sector":
        wanted_function = location_sector

    page_link = wanted_function(api_url)
    while page_link["next"] != page_link["last"]:
        page_link = wanted_function(page_link["next"])

    if(page_link["first"] != page_link["last"]):
        wanted_function(page_link["next"])

def main():
    pagination(url + "/api/1.0/locations?filter[status]=enabled", "location/sector")
    Location_id = input("Enter the ID of the Location you wish to use: ")
    pagination(url + "/api/1.0/locations/" + Location_id +"/sectors", "location/sector")
    Sector_id = input("Enter the ID of the Sector you wish to add the device to:")
    pagination(url + "/api/1.0/devices", "device")

    Device_id = input("Enter the Serialnumber of the device you wish to associate: ")
    date_time = datetime.now().strftime("%Y-%m-%dT%H:%M:%S")

    payload = json.dumps({
      "device_name": Device_id,
      "start_timestamp": date_time + "+00:00"
    })

    response = requests.request("POST", url +"/api/1.0/sectors/"+ Sector_id +"/associations", headers=headers, data=payload)

    if response.status_code in [201]:
            print("Device assigend sucesfully" )
    else:
        print(response.text)
        quit()

if __name__ == "__main__":
    main()
